/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.HistoryDialog;

import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.dialogs.HistoryDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import org.apache.commons.io.FilenameUtils;

public class HistoryDialogController {
    public HistoryDialog dialog;
    public boolean hack_clearing;
    private GrammarEditorShell formGrammar;

    public HistoryDialogController(HistoryDialog historyDialog) {
        this.dialog = historyDialog;
        if (this.dialog.tv != null) {
            ((DefaultMutableTreeNode)this.dialog.tv.getModel().getRoot()).removeAllChildren();
            ((DefaultTreeModel)this.dialog.tv.getModel()).reload();
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("+");
        ((DefaultTreeModel)this.dialog.tv.getModel()).setRoot(top);
    }

    public void updateNewFor(GrammarEditorShell fg) {
        this.formGrammar = fg;
        Graph grf = this.formGrammar.getController().grf;
        if (grf == null) {
            return;
        }
        this.hack_clearing = true;
        if (this.dialog.tv != null) {
            ((DefaultMutableTreeNode)this.dialog.tv.getModel().getRoot()).removeAllChildren();
            ((DefaultTreeModel)this.dialog.tv.getModel()).reload();
        }
        this.hack_clearing = false;
        String filename = "";
        if (this.formGrammar.getController().getFullName() != null) {
            filename = FilenameUtils.removeExtension(new File(this.formGrammar.getController().getFullName()).getName());
        }
        this.dialog.setTitle(filename + ":" + grf.name);
        if (grf.history != null) {
            for (int imodifs = 0; imodifs < grf.history.size(); imodifs += 2) {
                String modification = (String)grf.history.get(imodifs);
                DefaultMutableTreeNode tnode = new DefaultMutableTreeNode(modification);
                ((DefaultMutableTreeNode)this.dialog.tv.getModel().getRoot()).add(tnode);
            }
        }
        HistoryDialogController.setTreeState(this.dialog.tv, true);
        try {
            this.formGrammar.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
        this.formGrammar.invalidate();
        this.formGrammar.repaint();
        this.dialog.setTitle("History of " + filename);
    }

    public void updateCurrentFor(GrammarEditorShell fg) {
        this.formGrammar = fg;
        Graph grf = this.formGrammar.getController().grf;
        for (int inode = 0; inode < ((DefaultMutableTreeNode)this.dialog.tv.getModel().getRoot()).getChildCount(); ++inode) {
            int imodif = inode * 2;
            if (imodif >= grf.iHistory) continue;
        }
        try {
            this.formGrammar.setSelected(true);
        }
        catch (PropertyVetoException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
        HistoryDialogController.setTreeState(this.dialog.tv, true);
        this.formGrammar.invalidate();
        this.formGrammar.repaint();
    }

    private static void setTreeState(JTree tree, boolean expanded) {
        Object root = tree.getModel().getRoot();
        HistoryDialogController.setTreeState(tree, new TreePath(root), expanded);
    }

    private static void setTreeState(JTree tree, TreePath path, boolean expanded) {
        Object lastNode = path.getLastPathComponent();
        for (int i = 0; i < tree.getModel().getChildCount(lastNode); ++i) {
            Object child = tree.getModel().getChild(lastNode, i);
            TreePath pathToChild = path.pathByAddingChild(child);
            HistoryDialogController.setTreeState(tree, pathToChild, expanded);
        }
        if (expanded) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }
}

